<?php
if(!isset($conn)) {
    require_once 'config.php';
}
?>
<!-- Mobile Sidebar Toggle -->
<div class="md:hidden fixed inset-0 z-50" id="mobileSidebar" style="display: none;">
    <div class="fixed inset-0 bg-black bg-opacity-50" onclick="toggleSidebar()"></div>
    <div class="fixed inset-y-0 left-0 w-64 bg-white shadow-xl transform transition-transform -translate-x-full">
        <div class="p-6">
            <div class="flex items-center justify-between mb-8">
                <h2 class="text-xl font-bold text-gray-800">Menu</h2>
                <button onclick="toggleSidebar()" class="text-gray-500 hover:text-gray-700">
                    <i class="fas fa-times text-xl"></i>
                </button>
            </div>
            <?php include 'includes/sidebar.php'; ?>
        </div>
    </div>
</div>

<!-- Header -->
<header class="bg-white shadow-sm border-b sticky top-0 z-40">
    <div class="px-6 py-4 flex items-center justify-between">
        <div class="flex items-center">
            <button onclick="toggleSidebar()" class="md:hidden text-gray-600 hover:text-gray-800 mr-4">
                <i class="fas fa-bars text-xl"></i>
            </button>
            <a href="index.php" class="text-2xl font-bold text-blue-600 hover:text-blue-700">
                <i class="fas fa-rocket mr-2"></i>ProjectSale
            </a>
        </div>
        
        <div class="flex items-center space-x-4">
            <!-- Notifications -->
            <div class="relative group">
                <button class="w-10 h-10 rounded-full bg-gray-100 hover:bg-gray-200 flex items-center justify-center transition duration-300">
                    <i class="fas fa-bell text-gray-600"></i>
                    <?php
                    if(isLoggedIn()) {
                        $user_id = $_SESSION['user_id'];
                        $pending_count = $conn->query("SELECT COUNT(*) as count FROM orders WHERE user_id = $user_id AND status = 'pending'")->fetch_assoc()['count'];
                        if($pending_count > 0):
                    ?>
                    <span class="absolute -top-1 -right-1 w-5 h-5 bg-red-500 text-white text-xs rounded-full flex items-center justify-center">
                        <?php echo $pending_count; ?>
                    </span>
                    <?php endif; } ?>
                </button>
                <div class="absolute right-0 mt-2 w-80 bg-white rounded-lg shadow-xl py-2 z-50 hidden group-hover:block">
                    <div class="px-4 py-2 border-b">
                        <h4 class="font-bold text-gray-800">Notifications</h4>
                    </div>
                    <div class="max-h-60 overflow-y-auto">
                        <?php
                        if(isLoggedIn()) {
                            $notifications = $conn->query("
                                SELECT * FROM orders 
                                WHERE user_id = $user_id AND status = 'pending'
                                ORDER BY created_at DESC LIMIT 5
                            ");
                            
                            if($notifications->num_rows > 0) {
                                while($notif = $notifications->fetch_assoc()) {
                                    echo '<a href="my-orders.php" class="block px-4 py-3 hover:bg-gray-50 border-b">
                                            <p class="text-sm text-gray-800">New order pending</p>
                                            <p class="text-xs text-gray-500">Order #' . $notif['id'] . '</p>
                                          </a>';
                                }
                            } else {
                                echo '<div class="px-4 py-3 text-center text-gray-500">
                                        <i class="fas fa-bell-slash text-2xl mb-2"></i>
                                        <p>No notifications</p>
                                      </div>';
                            }
                        }
                        ?>
                    </div>
                </div>
            </div>
            
            <!-- User Menu -->
            <?php if(isLoggedIn()): ?>
            <div class="relative group">
                <button class="flex items-center space-x-2 text-gray-700 hover:text-blue-600">
                    <div class="w-10 h-10 bg-gradient-to-r from-blue-500 to-purple-500 rounded-full flex items-center justify-center text-white font-bold">
                        <?php echo strtoupper(substr($_SESSION['username'], 0, 1)); ?>
                    </div>
                    <span class="hidden md:inline font-medium"><?php echo $_SESSION['username']; ?></span>
                    <i class="fas fa-chevron-down text-sm"></i>
                </button>
                <div class="absolute right-0 mt-2 w-48 bg-white rounded-lg shadow-xl py-2 z-50 hidden group-hover:block">
                    <div class="px-4 py-2 border-b">
                        <p class="text-sm text-gray-600">Balance: ৳<?php 
                            echo number_format(getUserBalance($_SESSION['user_id']), 2);
                        ?></p>
                    </div>
                    <a href="profile.php" class="block px-4 py-2 text-gray-700 hover:bg-blue-50 hover:text-blue-600">
                        <i class="fas fa-user mr-2"></i> Profile
                    </a>
                    <a href="dashboard.php" class="block px-4 py-2 text-gray-700 hover:bg-blue-50 hover:text-blue-600">
                        <i class="fas fa-tachometer-alt mr-2"></i> Dashboard
                    </a>
                    <div class="border-t mt-2 pt-2">
                        <a href="logout.php" class="block px-4 py-2 text-gray-700 hover:bg-red-50 hover:text-red-600">
                            <i class="fas fa-sign-out-alt mr-2"></i> Logout
                        </a>
                    </div>
                </div>
            </div>
            <?php else: ?>
            <div class="flex items-center space-x-3">
                <a href="login.php" class="text-gray-700 hover:text-blue-600 font-medium">
                    <i class="fas fa-sign-in-alt mr-1"></i> Login
                </a>
                <a href="register.php" class="bg-blue-500 text-white px-4 py-2 rounded-lg hover:bg-blue-600 transition duration-300">
                    <i class="fas fa-user-plus mr-1"></i> Register
                </a>
            </div>
            <?php endif; ?>
        </div>
    </div>
</header>

<script>
function toggleSidebar() {
    const sidebar = document.getElementById('mobileSidebar');
    const sidebarContent = sidebar.querySelector('.fixed.inset-y-0');
    
    if(sidebar.style.display === 'none' || sidebar.style.display === '') {
        sidebar.style.display = 'block';
        setTimeout(() => {
            sidebarContent.classList.remove('-translate-x-full');
        }, 10);
    } else {
        sidebarContent.classList.add('-translate-x-full');
        setTimeout(() => {
            sidebar.style.display = 'none';
        }, 300);
    }
}

// Close sidebar when clicking outside
document.addEventListener('click', function(event) {
    const sidebar = document.getElementById('mobileSidebar');
    const sidebarContent = sidebar.querySelector('.fixed.inset-y-0');
    const toggleBtn = document.querySelector('button[onclick="toggleSidebar()"]');
    
    if(sidebar.style.display === 'block' && 
       !sidebarContent.contains(event.target) && 
       !toggleBtn.contains(event.target)) {
        sidebarContent.classList.add('-translate-x-full');
        setTimeout(() => {
            sidebar.style.display = 'none';
        }, 300);
    }
});
</script>